/*  VersStr.c */


/************************************************************************************/
/*   Copyright Joseph Laffey, 1993.													*/

/*	 You may use this code snippet in anyhting you'd like							*/

/*   It would be cool if you could give me a little credit...  						*/
/************************************************************************************/


/************************************************************************************/
/*   Of course, USE AT YOUR OWN RISK; I'm not responsible for anything, etc., etc.	*/
/************************************************************************************/



/************************************************************************************/
/*  Gets the version number of a program from its 'vers' resource #1 as listed in 	*/
/*  the "short" version field.  The version is returned in a Pascal string passed 	*/
/*  as a paramater																	*/

/*  Assumes that the current resource file includes the appropriate 'vers' resource */
/************************************************************************************/


/* Assumes inclusion of MacHeaders */
#include <Resources.h>
#include <Memory.h>



/************************************************************************************/

#define	VERS_RES_ID		1	/* the resource ID of the 'vers' to use (usually 1 as of Sys7.1) */

#define	BYTE_OFFSET		6	/* the offset of the first byte containing the version  	*/
							/* from the beginning of the'vers' resource 				*/
							/*  Apple MAY change this-- hopefully not!!!  				*/

/************************************************************************************/


/************************************************************************************/

void	GetVersStr( Str255	theString );
	/* function prototype */

/************************************************************************************/




void	GetVersStr( Str255	theString )
{
	Handle	resHandle;		/* holds the 'vers' resource 		*/
	short	versStrLength;	/* the length of the version string */
	
	
	
	resHandle = Get1Resource( 'vers', VERS_RES_ID );  /* load in the resource */
	
	HLockHi( resHandle );	/* Lock the handle because we're BlockMoving */
	
	versStrLength = (short)( (unsigned char)(*(*resHandle	+ BYTE_OFFSET)) ); 
		/* get the length of the string from the first byte */																		
	
	
	BlockMove( (*resHandle + BYTE_OFFSET), theString, (versStrLength + 1) );
		/* copy the appropriate bytes into theString 							*/
		/* note the addition of 1 to versStrLength -- this gets the length byte */
	

	HUnlock( resHandle );			/* unlock the handle */
	
	ReleaseResource( resHandle );	/* release the resource from memory */



}  /* end of function GetVersStr */